#pragma once

#include <algorithm>

#include <library/cpp/zookeeper/zookeeper.h>

#include <util/stream/output.h>
#include <util/string/cast.h>
#include <util/system/condvar.h>
#include <util/system/guard.h>
#include <util/system/mutex.h>
#include <util/thread/factory.h>
#include <util/system/event.h>
#include <utility>

namespace NWebmaster {

struct TZooKeeperClient : public NZooKeeper::IWatcher {
    enum EState {
        ST_INIT,
        ST_NEW_SESSION,
        ST_RECONNECT,
        ST_CONNECTED,
        ST_NODE_DELETED
    };

    typedef THolder<TZooKeeperClient> Ptr;

public:
    TZooKeeperClient(const TString &connectionString, size_t timeout = 30000);
    ~TZooKeeperClient() override;

    std::pair<bool, int> Exists(const TString &path, bool watcher);
    void GetChildren(const TString &path, TVector<TString> &children);
    void SetState(EState state);
    bool WaitState(EState state, TDuration timeout) const;

    void NewSession();
    TString Create(const TString &path, const TString &data, NZooKeeper::ECreateMode createMode);
    void Delete(const TString &path, int version);
    void EnsureConnected() const;

private:
    void Process(const NZooKeeper::TWatchedEvent &event) override;

private:
    THolder<NZooKeeper::TZooKeeper> Client;
    TString ConnectionString;
    size_t Timeout;
    EState State;
    mutable TCondVar StateCond;
    mutable TMutex StateMutex;

public:
    TManualEvent OnNodeDeleted;
};

struct TZkMutex {
    TZkMutex(const TString &connectionString, const TString &path, const TString &lockPrefix = "lock-", size_t timeout = 30000);

    void Acquire();
    void Release();
    bool Alive();

private:
    bool GetSequenceId(const TString &path, int &seq);
    bool GetMinSequenceId(const TVector<TString> &children, int &seq);

private:
    TString Path;
    TString LockedPath;
    TString LockPrefix;
    size_t Timeout;
    TZooKeeperClient ZooKeeper;
};

} //namespace NWebmaster
