# YandexIO SDK

Общий код SDK для построения умных устройств с Алисой.

Специфичный для наших устройств код размещается в `/smart_devices`.


# Текущее состояние
## Внешние Компоненты
1) **Кнопки** - Каждая платформа имеет свою реализацию кнопок и она не связана с IOSDK. Вендор сам решает какие действия завязаны на какие кнопки:
Пример: https://a.yandex-team.ru/arc/trunk/arcadia/smart_devices/platforms/jbl_link/portable/ButtonsHandler.cc
2) **Леды** (LEDs) - IO SDK предоставляет свою дефолтную реализацию для LedManager, который может рисовать анимации используя платформенную реализацию LedController-а: https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/modules/leds. Однако решение, какую анимацию в какой ситуации рисовать остается за вендором. Пример "простой" реализации: https://a.yandex-team.ru/arc/trunk/arcadia/smart_devices/platforms/yandexstation/leds . Такой подход к ледам позволяет делать кастомные анимации, которых нет на других колонках (как пример: анимации bluetooth на jbl: https://a.yandex-team.ru/arc/trunk/arcadia/smart_devices/platforms/jbl_link/common/JBLBluetoothObserver.cc?rev=7588439#L31). Так же этот подход позволяет делать и более сложные решения для девайсов с несколькими потребителями анимаций: Станция-2 (https://a.yandex-team.ru/arc/trunk/arcadia/smart_devices/platforms/yandexstation/leds) и Мини-2. 
Минусом такого подхода является копипаста на платформах с минимальными отличиями в реализациях анимаций (Irbis и Dexp)
3) **Громкость**  - Каждый вендор имеет свою реализацию для громкости и шкалу. IO SDK предоставляет дефолтный VolumeManager (https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/modules/volume_manager). VolumeManager является дефолтной имплементацией для сценариев колонки (изменение громкости голосом, по будильнику, для напоминаний, таймеров и тд). Также он предоставляет АПИ для управления громкостью кнопками. 
Пути развития:
              1. На данный момент является монолитом, что мешает добавлять кастомные сценарии (как пример: управление громкостью через RCU. Пришлось в общий VolumeManager протаскивать понятия SourceType-а чтобы рисовать нужную анимацию). Возможно нужна декомпозиция
              2. На данный момент в Quasar все еще есть ручное управление громкостью: https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/services/firstrund/FirstRunEndpoint.cc?rev=7612720#L721-728   + сохранение настроек про громкость: https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/services/alarmd/AlarmEndpoint.cc?rev=7612720#L71-74 . Нужно вынести это все наружу с гарантиями, что громкость будет изменена до того, как .wav файл будет проигран (например при настройке)
4) **Входной источник звука** (микрофоны)
IO SDK предоставляет простое API для подачи звука для Алисы (и других потребителей): https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/sdk/audio_source?rev=7612720 . Помимо этого SDK предоставляет набор простых модулей, которые могут быть использованы для последующей интеграции:
https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/modules/audio_input?rev=7612720. 
Т.е. на данный момент для интеграции входного звука вендору необходимо написать свою имплементацию  AudioDevice-а (с vqe и прочим) и дальше использовать модульные **AudioInputController**-ы (или при необходимости написать свой). Помимо AudioInputController-а среди модулей есть: **IMicsStateProvider** (и пара имплементаций) - внешний провайдер состояния микрофонов. На некоторых девайсах mute хардварных, а на некоторых софтварный. Это позволяет не смешивать их и гарантировать корректную работу. AudioDumper - простой клиент **AudioSource-**а, который дампит звук на флешку по USR1/USR2 сигналам. **BrokenMicDetector** - клиент AudioSource-а, который анализирует данные с микрофонов и логирует  "битые" каналы


## Внутренние сервисы
### Core
1) **aliced** https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/services/aliced :
Ключевой компонент SDK: обеспечивает взаимодействие с алисой. Функции:
* Запросы к бекендам алисы (агрегация состояния девайса и получение директив)
* Синтез Алисы (+ jingle)
* Контроль состояния (aliceState - от него зависит oknyx и анимации ледов)
* Аудиофокус (управление фокуса контента)
* Остановка будильников/таймеров
* Клиент pushd - serverAction-ы с бекенда (напоминание, ютуб из пп)
* Логирование звука на юнипроксе
* Логирование звука "сломанных микрофонов" (связан с BrokenMicDetector
2) **syncd** https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/services/syncd :
Компонент отвечающий за получение рантайм конфига (пользовательского (device/user config-и) + бекендного (system_config). Функции:
* Ходить в ручку get_sync_info и рассылать полученный конфиг (внутренним сервисам и юзеру sdk)
3) **pushd** https://a.yandex-team.ru/arc/trunk/arcadia/yandex_io/services/pushd :
Компонент отвечающий за Пуши в колонках. Функции: 
* Подписываться на xiva-у и рассылать содержимое пушей клиентам
4) **authd**
Сервис, который получает из паспорта oauth токен и хранит его. Функции:
* Получить токен при настройке
* Рассылать токен клиентам
* Обновлять токен при протухании
5) **firstrund**
Сервис "настройки" девайса. Сервис решает считается ли девайс настроеным. если девайс не настроен - говорит .wav-ки и рассылает состояние клиентам. Функции:
* Переводить девайс в состоянии Configuring/Configured
* Следить за состоянием настройки (подключение wifi, получение токена через authd, поход в ручку register)
* UX настройки: Играет .wav-ки, меняет громкость, управляет блютузом
* Поднимать AccessPoint скриптами для настройки через wifi
* Пинать wifid чтобы тот делал reconfigure, когда нет интернета (??????)
6) **sound_initd**
Подсервис настройки. Функции:
* Клиент YandexIO::AudioSource-а
* Распознавать R2D2 пилюк и находить в нем wifi/ethernet credentials и auth code и после этого передавать управление firstrund
7) **setupd**
Подсервис настройки. Функции:
* Получить данные от sound_initd или bled и передать управление firstrund
### Media функционал
1) **playbackd**
Простой сервис, который может сыграть .wav/.mp3. Функции:
* Получить название .wav/.mp3  и сыграть N раз
2) **mediad** / **audioclient** 
Два сервиса (старый и новый) для проигрывание Музыкального/Радио контента. Функции:
* Получить url и сыграть его (в случае mediad и старой музыки схема сложнее, но она deprecated)
3) **multiroomd**
Сервис для мультирума. Функции:
* Найти колонки в одной сети
* синхронизировать часы между колонками
* синхронизировать проигрываемый стрим
4) **videod**
**TODO**
5) **notificationd**
Сервис нотификаций. Функции:
* Получить пуш от сервера о том, что появилась нотификация
* Пробросить в SDK сообщение о наличии нотификации (чтобы maind нарисовал анимацию)
* Сыграть звук о получении нотификации
6) **do_not_disturb**
Сервис "не беспокоить". Функции:
* Получать настройки о том, когда юзер не хочет получать нотификации и звонки
* Пробрасывать do_not_disturb состояние клиентам
7) **calld**
Сервис звонков. Функции:
* Клиент AudioSource
* Получать пуши о входящем звонке
* Установка сессии звонка
* Рассылка состояния звонка (для ледов)
* Отправка .wav-ки входящего звонка в playbackd
8) **alarmd**
Сервис будильников/таймеров. Функции:
* Получение команд от external_commandsd
* Парсинг icalendar state-а, хранение будильников и таймеров на флешке
* Играть таймеры/будильники
* Отправка на проигрывание локальной .wav-ки будильника в playbackd
* Хранение настроек громкости будильника (и передача в volumeManager)
* Хранение настроек муз будильника
* Отправка serverAction-а для муз будильника в aliced ( + ожидание начала проигрывания от mediad)
9) **interfaced**
Java сервис с ui-ем алисы и видео сценариями. Функции:
* **TODO**

### Роутеры директив

1) **external_commands**
Простой сервис, который преобразует json в protobuf и отправляет директиву клиенту. Функции:
* Получить json, преобразовать его в протобуф и отправить нужному клиенту

### Метричные сервисы
1) **metricad**
Сервис, который отправляет метрики в сервис appmetrica. Функции:
* Получать reportEvent/reportError метрики и слать их в appMetrica
* Считать latencyPoints клиентских запросов
2) **metrica2d**
Сервис, который отправляет метрики в clickdaemon. Функции:
* Получать reportEvent/reportError метрики и слать их в appMetrica
* Считать latencyPoints клиентских запросов
3) **monitord**
Сервис сбора системных метрик. Функции:
* Собирать статистику состояния девайса: cpu, свободная память, температура, состояние партиций и тд
4) **fluent-bitd**
Сервис отправки логов в yt. Функции:
* Поддерживать работу демона fluent-bit: подготавливать конфигурационные файлы на запуске, при получении обновления конфига от syncd обновлять их и рестартовать fluent-bit

### Сервисы настройки сети
1) **wifid**
Сервис, который управляет wifi-ем. Функции:
* Клиент wpa_supplicant-а (или WifiManager-a)
* Установка соединения с wifi по запросу
* Контроль скорости подключения и проверка наличия интернета (generate_204)
2) **networkd**
Сервис настройки wifi и ethernet. Функции:
* Настройки  ethernet соединения
* Прокся к wifid

### Опциональные сервисы
1) **ble**
Сервис настройки через ble. Функции:
* Управление ble (адвертайзинг, чтение и запись характеристик)
* Проксирование данных в setupd (для дальнейшей настройки)
2) **glagold**
Сервис управления девайсом в локальной сети. Функции:
* Avahi адвертайзинг
* Поднятие websocket server-а в локальной сети
* Получение команд через glagol_sdk и проксирование их клиентам (aliced, external_commandsd, volumeManager)

### Обновления
1) **updatesd**
Сервис установки обновлений. Функции:
1) Ходить в бекенд в ручку check updates
2) На старте сообщать sdk о том было ли установлено обновление
3) Получать команды от quasar о том, можно ли начать установку обновления
4) Рассылать состояние обновления (и прогресс скачивания)
5) Установка обновления платформенным скриптом
6) Получать таймзону от geolocation модуля для установки обновления в локальной таймзоне

### И другие...
1) **adbd**
Сервис управления adb. Функции:
* получение настроек от syncd
* Включение / выключение adb
2) **audiosender**
Опциональный разработческий сервис для логирования звука. Функции:
* Собственный инстанс SpeechkitEndpoint
* клиент AudioSource
* Вебсокет сервер в локальной сети для управления логированием (?)
* **todo: more**
3) **iot**
Сервис для настройки лампочек. Функции:
* Настройка лампочек через апи алисы и бекенд iot
* **todo: more**
4) **ntpd**
Сервис установки времени на колонке. Функции:
* Поход в ntp сервера для получения точного времени
* Установка времени
* **todo: more**
5) **stated**
Сервис для отправки версии прошивки.Функции:
* Получение версии от YandexIOSDK и отправка ее в бекенд
6) **braind**
Сервис сборка стейта устройства для отправки в SDK. Функции:
* Сбор состояния разных сервисов: aliced, firstrund, mediad, alarmd, etc...
* Отправка состояния через DeviceContext в виде YandexIO::DeviceState-а
7) **brickd**
Сервис для "красных" (подписочных) колонок. Внутренний сервис, который по конфигу syncd понимает что юзер не купил колонку,а получил ее по особой подписке. Функции:
* Клиент конфига syncd
* Рассылает brick state клиентам

### experimental note
