#include "audio_source_jni.h"

#include "jni_utils.h"

#include <yandex_io/android_sdk/cpp/launcher/global_context.h>

#include <yandex_io/libs/ipc/mixed/mixed_ipc_factory.h>
#include <yandex_io/protos/yandex_io.pb.h>
#include <yandex_io/sdk/audio_source/i_audio_source.h>
#include <yandex_io/sdk/audio_source/socket/audio_source_utils.h>

#include <thread>

using namespace quasar;

namespace {
    std::shared_ptr<YandexIO::IAudioSource> gAudioSource;

    void ensureInitialized() {
        if (!gAudioSource) {
            gAudioSource = YandexIO::createAudioSource(GlobalContext::get().getIpcFactory());
        }
    }
} // namespace

JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_AudioSource_doPushAudioData(JNIEnv* env, jobject /*obj*/, jbyteArray audioDataSerialized) {
    ensureInitialized();

    try {
        TInputDataWrapper input(env, audioDataSerialized);

        quasar::proto::IOAudioData audioData;
        Y_PROTOBUF_SUPPRESS_NODISCARD audioData.ParseFromArray(input.Bytes, input.Size);
        gAudioSource->pushData(convert(audioData));

    } catch (...) {
        ThrowJavaException(env, "java/lang/Exception", CurrentExceptionMessage().c_str());
    }
}
