#include "device_utils_jni.h"

#include "jni_utils.h"

#include <yandex_io/libs/base/utils.h>

using namespace quasar;

/*
 * Class:     ru_yandex_io_sdk_jni_DeviceUtils
 * Method:    doNativeCalcSsidHashcode
 * Signature: (Ljava/lang/String;)I;
 */
JNIEXPORT jint JNICALL Java_ru_yandex_io_sdk_jni_DeviceUtils_doNativeCalcSsidHashcode(JNIEnv* env, jobject /*obj*/, jstring jstrSsid)
{
    const jsize strSize = env->GetStringUTFLength(jstrSsid);
    const char* charBuffer = env->GetStringUTFChars(jstrSsid, (jboolean*)nullptr);
    std::string ssid(charBuffer, strSize);

    return javaStyleStringHash(ssid);
}
