#include "jni_account_manager_jni.h"

#include <yandex_io/android_sdk/cpp/launcher/account_manager.h>
#include <yandex_io/android_sdk/cpp/launcher/global_context.h>
#include <library/cpp/jni/jni.h>

#include <yandex_io/libs/logging/logging.h>

using namespace quasar;

class JavaAccountManagerWrapper: public AccountManager {
public:
    JavaAccountManagerWrapper(JNIEnv* env, jobject instance)
        : accountManagerClass_(env->GetObjectClass(instance))
        , accountManagerInstance_(instance)
        , switchUserMethodID_(env->GetMethodID(accountManagerClass_.Get(), "switchUser", "(Ljava/lang/String;)V"))
    {
    }

    virtual ~JavaAccountManagerWrapper() {
        accountManagerClass_.Release();
        accountManagerInstance_.Release();
    }

    void switchUser(const std::string& xCode) override {
        auto env = NJni::Env();
        auto jxCode = env->NewStringUTF(xCode);
        env->CallVoidMethod(accountManagerInstance_.Get(), switchUserMethodID_, jxCode.Get());
    }

private:
    NJni::TGlobalClassRef accountManagerClass_;
    NJni::TGlobalRef accountManagerInstance_;
    jmethodID switchUserMethodID_;
};

/*
 * Class:     ru_yandex_io_sdk_jni_JniAccountManager
 * Method:    doRegister
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniAccountManager_doRegister(JNIEnv* env, jobject instance) {
    GlobalContext::get().setAccountManager(std::make_shared<JavaAccountManagerWrapper>(env, instance));
}

/*
 * Class:     ru_yandex_io_sdk_jni_JniAccountManager
 * Method:    doUnregister
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniAccountManager_doUnregister(JNIEnv* /*jenv*/, jobject /*obj*/) {
    GlobalContext::get().setAccountManager(nullptr);
}
