#include "jni_pinger_jni.h"

#include "jni_utils.h"

#include <yandex_io/android_sdk/cpp/launcher/global_context.h>

using namespace quasar;

//
//  Native methods
//

/*
 * Class:     ru_yandex_io_sdk_jni_JniPinger
 * Method:    startQuickPings
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniPinger_startQuickPings(JNIEnv* env, jobject, jstring jreason) {
    // Will actually use a wrapper over PingManager later, but logging implementation is ok as a stub for now.
    const auto pingManagerWrapper = quasar::GlobalContext::get().getPingManagerWrapper();
    const auto reason = jstring_to_stdstring(env, jreason);
    pingManagerWrapper->startQuickPings(reason);
}
