#include "jni_telemetry_params_jni.h"

#include "jni_utils.h"

#include <yandex_io/android_sdk/cpp/launcher/global_context.h>

#include <yandex_io/libs/telemetry/telemetry.h>

#include <vector>

using namespace quasar;
using namespace YandexIO;

namespace {

    const std::unordered_map<std::string, ITelemetry::IParams::NetworkStatus::Status> CONNECTION_STATUSES = {
        {"NOT_CONNECTED", ITelemetry::IParams::NetworkStatus::NOT_CONNECTED},
        {"CONNECTING", ITelemetry::IParams::NetworkStatus::CONNECTING},
        {"CONNECTED_NO_INTERNET", ITelemetry::IParams::NetworkStatus::CONNECTED_NO_INTERNET},
        {"CONNECTED", ITelemetry::IParams::NetworkStatus::CONNECTED},
        {"NOT_CHOSEN", ITelemetry::IParams::NetworkStatus::NOT_CHOSEN},
    };

    const std::unordered_map<std::string, ITelemetry::IParams::ConnectionType> CONNECTION_TYPES = {
        {"UNKNOWN", ITelemetry::IParams::ConnectionType::UNKNOWN},
        {"WIFI", ITelemetry::IParams::ConnectionType::WIFI},
        {"ETHERNET", ITelemetry::IParams::ConnectionType::ETHERNET},
    };

} // namespace

JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniTelemetryParams_setNetworkStatus(JNIEnv* env, jobject /*obj*/, jobject status, jobject type) {
    jclass enumClass = env->FindClass("java/lang/Enum");
    jmethodID nameMethodID = env->GetMethodID(enumClass, "name", "()Ljava/lang/String;");

    const std::string statusName = jstring_to_stdstring(env, static_cast<jstring>(env->CallObjectMethod(status, nameMethodID)));
    auto statusEntry = CONNECTION_STATUSES.find(statusName);
    if (statusEntry == CONNECTION_STATUSES.end()) {
        ThrowJavaException(env, "java/lang/IllegalArgumentException", "status");
        return;
    }

    const std::string typeName = jstring_to_stdstring(env, static_cast<jstring>(env->CallObjectMethod(type, nameMethodID)));
    auto typeEntry = CONNECTION_TYPES.find(typeName);
    if (typeEntry == CONNECTION_TYPES.end()) {
        ThrowJavaException(env, "java/lang/IllegalArgumentException", "type");
        return;
    }

    const auto networkStatus = ITelemetry::IParams::NetworkStatus{
        statusEntry->second,
        typeEntry->second,
    };
    GlobalContext::get().getDevice()->telemetry()->params()->setNetworkStatus(networkStatus);
    GlobalContext::get().getPingManagerWrapper()->setNetworkStatus(networkStatus);
}

JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniTelemetryParams_setWifiNetworks(JNIEnv* env, jobject /*obj*/, jobject networks) {
    jclass listClass = env->GetObjectClass(networks);
    jmethodID sizeMethodID = env->GetMethodID(listClass, "size", "()I");
    jmethodID getMethodID = env->GetMethodID(listClass, "get", "(I)Ljava/lang/Object;");

    jclass networkClass = env->FindClass("ru/yandex/io/sdk/telemetry/WifiNetwork");
    jmethodID getMacMethodID = env->GetMethodID(networkClass, "getMac", "()Ljava/lang/String;");
    jmethodID getLevelMethodID = env->GetMethodID(networkClass, "getLevel", "()I");
    jmethodID getSsidMethodID = env->GetMethodID(networkClass, "getSsid", "()Ljava/lang/String;");
    jmethodID getConnectedMethodID = env->GetMethodID(networkClass, "getConnected", "()Z");

    jint size = env->CallIntMethod(networks, sizeMethodID);

    std::vector<ITelemetry::IParams::WifiNetwork> wifiNetworks;
    wifiNetworks.reserve(size);

    for (jint i = 0; i < size; i++) {
        jobject network = env->CallObjectMethod(networks, getMethodID, i);

        jstring mac = static_cast<jstring>(env->CallObjectMethod(network, getMacMethodID));
        jint level = env->CallIntMethod(network, getLevelMethodID);
        jstring ssid = static_cast<jstring>(env->CallObjectMethod(network, getSsidMethodID));
        jboolean connected = env->CallBooleanMethod(network, getConnectedMethodID);

        wifiNetworks.push_back(ITelemetry::IParams::WifiNetwork{
            jstring_to_stdstring(env, mac),
            level,
            jstring_to_stdstring(env, ssid),
            connected == JNI_TRUE,
        });
    }

    GlobalContext::get().getDevice()->telemetry()->params()->setWifiNetworks(wifiNetworks);
}

JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniTelemetryParams_setLocation(JNIEnv* /*jenv*/, jobject /*obj*/, jdouble lat, jdouble lon) {
    GlobalContext::get().getDevice()->telemetry()->params()->setLocation(lat, lon);
}

JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniTelemetryParams_setTimezone(JNIEnv* env, jobject /*obj*/, jstring name, jint offsetSec) {
    GlobalContext::get().getDevice()->telemetry()->params()->setTimezone(jstring_to_stdstring(env, name), offsetSec);
}

JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniTelemetryParams_setConfig(JNIEnv* env, jobject /*obj*/, jstring config) {
    GlobalContext::get().getDevice()->telemetry()->params()->setConfig(jstring_to_stdstring(env, config));
}
