#pragma once

#include <util/generic/yexception.h>

#include <jni.h>

#include <map>
#include <string>

namespace quasar {

    struct TInputDataWrapper {
        TInputDataWrapper(JNIEnv* env, jbyteArray input);

        TInputDataWrapper(const TInputDataWrapper&) = delete;

        ~TInputDataWrapper();

        JNIEnv* Env;
        jbyteArray Input;
        jbyte* Bytes;
        jsize Size;
    };

    void ThrowJavaException(JNIEnv* env, const char* cls, const char* message);

    std::string jstring_to_stdstring(JNIEnv* env, jstring jStr);

    jobject std_string_string_map_to_jhashmap(JNIEnv* env, const std::map<std::string, std::string>& map);
} // namespace quasar
