#include "jni_vins_response_preprocessor.h"

#include "jni_utils.h"

#include <library/cpp/jni/jni.h>
#include <yandex_io/android_sdk/cpp/sdk_singleton/sdk_singleton.h>

#include <yandex_io/libs/logging/logging.h>

#include <string>

using namespace quasar;

class PreprocessorWrapper {
public:
    PreprocessorWrapper(
        JNIEnv* env,
        jobject preprocessor)
        : preprocssor_(preprocessor)
        , handleMethod_(
              env->GetMethodID(
                  env->GetObjectClass(preprocessor),
                  "handle",
                  "(Ljava/lang/String;)Ljava/lang/String;"))
    {
    }

    std::string handle(std::string param) {
        auto env = NJni::Env();
        auto jparam = env->NewStringUTF(param);
        auto jresultRef = env->CallObjectMethod(
            preprocssor_.Get(),
            handleMethod_,
            jparam.Get());
        jobject jresult = jresultRef.Get();
        jstring stringResult = (jstring)jresult;
        return std::string(env->GetStringUTFChars(stringResult, nullptr));
    }

private:
    NJni::TGlobalRef preprocssor_;
    jmethodID handleMethod_;
};

/*
 * Class:     ru_yandex_io_sdk_jni_JniVinsResponsePreprocessorHandler
 * Method:    doRegister
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_JniVinsResponsePreprocessor_doRegister(
    JNIEnv* env,
    jobject preprocessor) {
    auto wrapper = std::make_shared<PreprocessorWrapper>(env, preprocessor);
    YandexIO::getSDKSingleton()->setVinsResponsePreprocessorHandler(
        [wrapper = std::move(wrapper)](std::string param) -> std::string {
            return wrapper->handle(param);
        });
}
