#include "quasar_launcher_jni.h"

#include "jni_utils.h"

#include <yandex_io/android_sdk/cpp/launcher/quasar_android_launcher.h>
#include <library/cpp/jni/jni.h>

#include <yandex_io/scaffolding/proto/config.pb.h>

#include <util/system/yassert.h>

#include <memory>

using namespace quasar;

namespace {
    std::unique_ptr<QuasarAndroidLauncher> jniGlobalLauncher;
} // namespace

//
//  Java entry/exit points
//

JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* jvm, void* /*reserved*/) {
    try {
        // RedirectStdioToAndroidLog(true);
        return NJni::Env()->Init(jvm);
    } catch (...) {
        Y_FAIL("Failed to init JNI: %s", CurrentExceptionMessage().c_str());
    }
    return NJni::JNI_VERSION;
}

JNIEXPORT void JNICALL JNI_OnUnload(JavaVM* jvm, void* /*reserved*/) {
    try {
        NJni::Env()->Cleanup(jvm);
    } catch (...) {
        Y_FAIL("Failed to cleanup JNI: %s", CurrentExceptionMessage().c_str());
    }
}

//
//  Native methods
//

/*
 * Class:     ru_yandex_quasar_android_app_QuasarLauncher
 * Method:    doNativeStart
 * Signature: ([B)V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_QuasarLauncher_doNativeStart(JNIEnv* env, jobject /*obj*/, jbyteArray configSerialized) {
    if (jniGlobalLauncher) {
        ThrowJavaException(env, "java/lang/Exception", "Quasar is already started");
        return;
    }

    try {
        TInputDataWrapper input(env, configSerialized);
        auto config = std::make_shared<LauncherConfig>();
        Y_PROTOBUF_SUPPRESS_NODISCARD config->ParseFromArray(input.Bytes, input.Size);

        jniGlobalLauncher = std::make_unique<QuasarAndroidLauncher>(config);
        jniGlobalLauncher->init();
        jniGlobalLauncher->start();
    } catch (...) {
        ThrowJavaException(env, "java/lang/Exception", CurrentExceptionMessage().c_str());
    }
}

/*
 * Class:     ru_yandex_quasar_android_app_QuasarLauncher
 * Method:    doNativeStop
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_QuasarLauncher_doNativeStop(JNIEnv* env, jobject /*obj*/) {
    if (!jniGlobalLauncher) {
        ThrowJavaException(env, "java/lang/Exception", "Quasar is not started");
        return;
    }

    try {
        jniGlobalLauncher->stop();
        jniGlobalLauncher.reset(nullptr);
    } catch (...) {
        ThrowJavaException(env, "java/lang/Exception", CurrentExceptionMessage().c_str());
    }
}
