#pragma once

#include <library/cpp/jni/jni.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/interfaces/i_capability.h>

namespace YandexIO {

    class JniCapabilityWrapper: public ICapability,
                                public std::enable_shared_from_this<JniCapabilityWrapper> {
    public:
        JniCapabilityWrapper(JNIEnv* env, jobject instance);

        ~JniCapabilityWrapper() override;

        const std::string& getId() const override;

        NAlice::TCapabilityHolder getState() const override;

        IDirectiveHandlerPtr getDirectiveHandler() override;

        void addListener(std::weak_ptr<IListener> wlistener) override;

        void removeListener(std::weak_ptr<IListener> wlistener) override;

        void onStateChanged(NAlice::TCapabilityHolder state);

    private:
        void init();

        NJni::TGlobalClassRef capabilityClass_;
        NJni::TGlobalRef capabilityInstance_;

        jmethodID getStateMethodId_;
        jmethodID getDirectiveHandlerMethodId_;

        std::string id_;
        std::list<std::weak_ptr<IListener>> listeners_;
    };

} // namespace YandexIO
