#pragma once

#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/interfaces/directive.h>
#include <library/cpp/jni/jni.h>

#include <set>

namespace YandexIO {
    class JniDirectiveHandlerWrapper: public IDirectiveHandler {
    public:
        JniDirectiveHandlerWrapper(JNIEnv* env, jobject instance);

        ~JniDirectiveHandlerWrapper() override;

        const std::string& getEndpointId() const override;

        const std::string& getHandlerName() const override;

        const std::set<std::string>& getSupportedDirectiveNames() const override;

        void handleDirective(const std::shared_ptr<Directive>& directive) override;

        void cancelDirective(const std::shared_ptr<Directive>& directive) override;

        void prefetchDirective(const std::shared_ptr<Directive>& directive) override;

    private:
        void init();

        void processDirectiveMethod(const jmethodID& methodId, const std::shared_ptr<Directive>& directive);

        NJni::TGlobalClassRef directiveHandlerClass_;
        NJni::TGlobalRef directiveHandlerInstance_;

        jmethodID handleDirectiveMethodId_;
        jmethodID cancelDirectiveMethodId_;
        jmethodID prefetchDirectiveMethodId_;

        std::string endpointId_;
        std::string handlerName_;
        std::set<std::string> supportedDirectives_;
    };
} // namespace YandexIO
