#include "yandex_io_endpoint_jni.h"

#include "jni_utils.h"

#include <library/cpp/jni/jni.h>

#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/interfaces/i_endpoint.h>
#include <yandex_io/android_sdk/cpp/sdk_singleton/sdk_singleton.h>
#include <yandex_io/android_sdk/cpp/jni/wrappers/jni_capability_wrapper.h>

using namespace quasar;

namespace {
    std::mutex capabilitiesMutex_;
    std::map<std::string, std::shared_ptr<YandexIO::JniCapabilityWrapper>> idToCapability_;
} // namespace
/*
 * Class:     ru_yandex_io_sdk_jni_YandexIoEndpoint
 * Method:    nativeAddCapability
 * Signature: (Lru/yandex/io/sdk/capability/Capability;)V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_YandexIoEndpoint_nativeAddCapability(JNIEnv* env, jobject instance, jobject javaCapability) {
    Y_UNUSED(instance);
    std::scoped_lock<std::mutex> lock(capabilitiesMutex_);
    const auto capability = std::make_shared<YandexIO::JniCapabilityWrapper>(env, javaCapability);
    idToCapability_[capability->getId()] = capability;

    YandexIO::getSDKSingleton()->getEndpointStorage()->getLocalEndpoint()->addCapability(capability);
}

/*
 * Class:     ru_yandex_io_sdk_jni_YandexIoEndpoint
 * Method:    nativeRemoveCapability
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_YandexIoEndpoint_nativeRemoveCapability(JNIEnv* env, jobject instance, jstring capabilityId) {
    Y_UNUSED(instance);
    std::scoped_lock<std::mutex> lock(capabilitiesMutex_);

    const auto id = jstring_to_stdstring(env, capabilityId);
    if (const auto it = idToCapability_.find(id); it != idToCapability_.end()) {
        const auto& capability = it->second;
        YandexIO::getSDKSingleton()->getEndpointStorage()->getLocalEndpoint()->removeCapability(capability);
        idToCapability_.erase(it);
    }
}

/*
 * Class:     ru_yandex_io_sdk_jni_YandexIoEndpoint
 * Method:    nativeOnCapabilityStateChanged
 * Signature: (Ljava/lang/String;[B)V
 */
JNIEXPORT void JNICALL Java_ru_yandex_io_sdk_jni_YandexIoEndpoint_nativeOnCapabilityStateChanged(JNIEnv* env, jobject instance, jstring capabilityId, jbyteArray capabilityState) {
    Y_UNUSED(instance);
    std::scoped_lock<std::mutex> lock(capabilitiesMutex_);
    const auto id = jstring_to_stdstring(env, capabilityId);
    if (const auto it = idToCapability_.find(id); it != idToCapability_.end()) {
        const auto& capability = it->second;

        TInputDataWrapper input(env, capabilityState);
        NAlice::TCapabilityHolder state;
        Y_PROTOBUF_SUPPRESS_NODISCARD state.ParseFromArray(input.Bytes, input.Size);

        capability->onStateChanged(state);
    }
}
