#pragma once

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/delay_timings_policy/delay_timings_policy.h>
#include <yandex_io/libs/device_cryptography/device_cryptography.h>
#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/yandex_iosdk.h>
#include <yandex_io/sdk/private/device_context.h>
#include <yandex_io/services/firstrund/check_token.h>

#include <mutex>
#include <random>

class GenericFirstRunService: public QuasarService {
public:
    GenericFirstRunService(std::shared_ptr<YandexIO::IDevice> device,
                           std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory,
                           std::shared_ptr<quasar::IAuthProvider> authProvider,
                           std::shared_ptr<quasar::IDeviceStateProvider> deviceStateProvider);

    virtual ~GenericFirstRunService();

    std::string getServiceName() const override;

    void start() override;

private:
    using OnRegistrationResult = YandexIO::DeviceContext::onRegistrationResult;
    struct BackendResponse {
        bool isSuccess;
        int code;
        std::string errorMessage;
        bool canRetry;
    };

    void onRegistrationRequested(const std::string& authToken, const std::string& passportUid, OnRegistrationResult onResult);

    void scheduleRegistrationFirstTime(std::string authToken, std::string uid, OnRegistrationResult onResult);

    void rescheduleRegistrationWithDelay(std::string authToken, std::string uid, int attemptsDone, OnRegistrationResult onResult);

    void doRegistration(std::string authToken, std::string uid, int attemptsDone, OnRegistrationResult onResult);

    BackendResponse registerOnBackend(const std::string& oauthToken);

    static bool canRetryAfterCode(int httpCode);

    void handlePushdMessage(const quasar::ipc::SharedMessage& message);

private:
    const std::shared_ptr<YandexIO::IDevice> device_;
    quasar::Lifetime lifetime_;
    std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory_;
    YandexIO::DeviceContext deviceContext_;

    quasar::proto::ConfigurationState currentConfigurationState_;

    std::shared_ptr<quasar::ipc::IServer> server_;
    std::shared_ptr<quasar::ipc::IConnector> pushdConnector_;

    std::string backendUrl_;
    std::string softwareVersion_;

    std::shared_ptr<quasar::IAuthProvider> authProvider_;
    std::unique_ptr<YandexIO::DeviceCryptography> deviceCryptography_;
    quasar::HttpClient backendClient_;

    quasar::CheckToken checkToken_;

    std::mutex registrationMutex_;
    std::mutex configurationStateMutex_;

    quasar::BackoffRetriesWithRandomPolicy backoffer_;
    quasar::Lifetime registrationLifetime_;
    quasar::NamedCallbackQueue registrationQueue_{"GenericFirstRunService"};
};
