#pragma once

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/ipc/i_server.h>
#include <yandex_io/libs/mdns/nsd_messager.h>
#include <yandex_io/sdk/backend_config_observer.h>
#include <yandex_io/services/glagold/glagol.h>

namespace quasar {

    class JniNsdMessagerFactory;

    class GlagolLauncherService: public QuasarService {
    public:
        GlagolLauncherService(std::shared_ptr<YandexIO::IDevice> device,
                              std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                              std::shared_ptr<IAuthProvider> authProvider,
                              std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
                              std::shared_ptr<IMultiroomProvider> multiroomProvider,
                              std::shared_ptr<IStereoPairProvider> stereoPairProvider,
                              INsdMessagerFactory& nsdMessagerFactory);

        virtual ~GlagolLauncherService();

        std::string getServiceName() const override;
        void start() override;
        void enableGlagolService(bool enabled);

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<IAuthProvider> authProvider_;
        std::shared_ptr<IDeviceStateProvider> deviceStateProvider_;
        std::shared_ptr<IMultiroomProvider> multiroomProvider_;
        std::shared_ptr<IStereoPairProvider> stereoPairProvider_;

        std::mutex serviceMutex_;
        std::shared_ptr<YandexIO::BackendConfigObserver> configObserver_;
        std::shared_ptr<ipc::IServer> stubService_;
        std::shared_ptr<Glagol> glagolService_;
        INsdMessagerFactory& nsdMessagerFactory_;
    };

} // namespace quasar
