#include "global_context.h"

using namespace quasar;

GlobalContext& GlobalContext::get()
{
    static GlobalContext instance;
    return instance;
}

std::shared_ptr<quasar::ipc::IIpcFactory> GlobalContext::getIpcFactory() const {
    std::shared_lock lock(mutex_);
    return weakIpcFactory_.lock();
}

void GlobalContext::setIpcFactory(std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory)
{
    std::scoped_lock lock(mutex_);
    weakIpcFactory_ = ipcFactory;
}

std::shared_ptr<AccountManager> GlobalContext::getAccountManager() const {
    std::shared_lock lock(mutex_);
    return accountManager_;
}

void GlobalContext::setAccountManager(std::shared_ptr<AccountManager> accountManager)
{
    std::scoped_lock lock(mutex_);
    accountManager_ = std::move(accountManager);
}

void GlobalContext::setDevice(std::shared_ptr<YandexIO::IDevice> device) {
    std::scoped_lock lock(mutex_);
    device_ = std::move(device);
}

std::shared_ptr<YandexIO::IDevice> GlobalContext::getDevice() const {
    std::shared_lock lock(mutex_);
    return device_;
}

void GlobalContext::setNsdMessagerFactory(std::shared_ptr<JniNsdMessagerFactory> nsdMessager) {
    std::scoped_lock lock(mutex_);
    nsdMessagerFactory_ = nsdMessager;
}

std::shared_ptr<JniNsdMessagerFactory> GlobalContext::getNsdMessagerFactory() const {
    std::shared_lock lock(mutex_);
    return nsdMessagerFactory_;
}

void GlobalContext::setPingManagerWrapper(std::shared_ptr<PingManagerWrapper> pingManagerWrapper) {
    std::scoped_lock lock(mutex_);
    pingManagerWrapper_ = pingManagerWrapper;
}

std::shared_ptr<PingManagerWrapper> GlobalContext::getPingManagerWrapper() const {
    std::shared_lock lock(mutex_);
    return pingManagerWrapper_;
}
