#pragma once

#include "account_manager.h"
#include "jni_nsd_messager_bridge.h"

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/mdns/nsd_messager.h>
#include <yandex_io/metrica/monitor/metrics_collector/ping_manager/ping_manager.h>
#include <yandex_io/android_sdk/cpp/metrics/ping_manager_wrapper/ping_manager_wrapper.h>

#include <memory>
#include <shared_mutex>

namespace quasar {

    class GlobalContext {
    public:
        static GlobalContext& get();

        std::shared_ptr<ipc::IIpcFactory> getIpcFactory() const;
        void setIpcFactory(std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory);

        std::shared_ptr<AccountManager> getAccountManager() const;
        void setAccountManager(std::shared_ptr<AccountManager> accountManager);

        void setDevice(std::shared_ptr<YandexIO::IDevice> device);
        std::shared_ptr<YandexIO::IDevice> getDevice() const;

        void setNsdMessagerFactory(std::shared_ptr<JniNsdMessagerFactory> nsdMessager);
        std::shared_ptr<JniNsdMessagerFactory> getNsdMessagerFactory() const;

        void setPingManagerWrapper(std::shared_ptr<PingManagerWrapper> pingManagerWrapper);
        std::shared_ptr<PingManagerWrapper> getPingManagerWrapper() const;

    private:
        mutable std::shared_mutex mutex_;
        std::shared_ptr<YandexIO::IDevice> device_;
        std::weak_ptr<ipc::IIpcFactory> weakIpcFactory_;
        std::shared_ptr<AccountManager> accountManager_;
        std::shared_ptr<JniNsdMessagerFactory> nsdMessagerFactory_;
        std::shared_ptr<PingManagerWrapper> pingManagerWrapper_;
    };

} // namespace quasar
