#pragma once

#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/mdns/nsd_messager.h>
#include <yandex_io/libs/mdns/nsd_receiver.h>

#include <memory>
#include <mutex>
#include <optional>
#include <vector>

namespace quasar {

    class NsdReceiverBridge: public INsdReceiver {
    public:
        void onNsdDiscovered(const proto::NsdInfo& nsdInfo) override;
        void onNsdListDiscovered(const proto::NsdInfoList& nsdInfoList) override;
        void onNsdLost(const proto::NsdInfo& nsdInfo) override;

        void setGlagolReceiver(INsdReceiver* receiver);

    private:
        INsdReceiver* receiver_;
        std::mutex mutex_;
    };

    class JniNsdMessagerBridge: public INsdMessager {
    public:
        JniNsdMessagerBridge();
        // JniNsdMessagerBridge(INsdReceiverPtr glagolReceiver);
        void enableNsd(bool guestMode, uint32_t port, OptBool stereopair, OptBool tandem) override;
        void disableNsd() override;
        void setJniMessager(INsdMessager* messager);

    private:
        bool guestMode_;
        uint32_t port_;
        OptBool stereopair_;
        OptBool tandem_;
        bool enableNsdSent_;
        INsdMessager* jniMessager_;
        std::mutex mutex_;
    };

    class JniNsdMessagerFactory: public INsdMessagerFactory {
    public:
        INsdMessagerPtr createMessager(INsdReceiverPtr receiver) override;
        INsdReceiver& nsdReceiver();
        void setJniNsdMessager(INsdMessagerPtr messager);

    private:
        std::weak_ptr<JniNsdMessagerBridge> glagolMessager_;
        INsdReceiverPtr glagolReceiver_;
        INsdMessagerPtr jniMessager_;
        NsdReceiverBridge nsdReceiverBridge_;
        std::mutex mutex_;
    };

} // namespace quasar
