#pragma once

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/clock_tower/i_clock_tower_provider.h>
#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/interfaces/glagol/i_glagol_cluster_provider.h>
#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/ipc/i_server.h>
#include <yandex_io/services/mediad/audio_clock_manager/audio_clock_manager.h>
#include <yandex_io/services/mediad/media_service.h>
#include <yandex_io/sdk/sdk_interface.h>

using namespace quasar;

class MediaLauncherService: public QuasarService {
public:
    MediaLauncherService(std::shared_ptr<YandexIO::IDevice> device,
                         std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                         std::shared_ptr<IAuthProvider> authProvider,
                         std::shared_ptr<IClockTowerProvider> clockTowerProvider,
                         std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
                         std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider,
                         std::shared_ptr<IMultiroomProvider> multiroomProvider,
                         std::shared_ptr<IStereoPairProvider> stereoPairProvider,
                         std::shared_ptr<IUserConfigProvider> userConfigProvider,
                         std::shared_ptr<YandexIO::SDKInterface> sdk);

    std::string getServiceName() const override;
    void start() override;

private:
    const std::shared_ptr<YandexIO::IDevice> device_;
    const std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
    const std::shared_ptr<IAuthProvider> authProvider_;
    const std::shared_ptr<IClockTowerProvider> clockTowerProvider_;
    const std::shared_ptr<IDeviceStateProvider> deviceStateProvider_;
    const std::shared_ptr<IGlagolClusterProvider> glagolClusterProvider_;
    const std::shared_ptr<IMultiroomProvider> multiroomProvider_;
    const std::shared_ptr<IStereoPairProvider> stereoPairProvider_;
    const std::shared_ptr<IUserConfigProvider> userConfigProvider_;
    const std::shared_ptr<YandexIO::SDKInterface> sdk_;

    std::mutex serviceMutex_;
    std::shared_ptr<AudioClockManager> audioClockManager_;
    std::unique_ptr<MediaService> mediaService_;
    std::shared_ptr<ipc::IServer> multiroomStubService_;
};
