#pragma once

#include <memory>

class LauncherConfig;

namespace quasar {
    class JniNsdMessagerFactory;
    class YandexIOEndpoint;
    namespace ipc {
        class IIpcFactory;
    } // namespace ipc
} // namespace quasar

namespace YandexIO {
    class IDevice;
    class XivaPushAliceRequester;
    class SpotterConfigurer;
} // namespace YandexIO

class QuasarAndroidLauncher {
public:
    QuasarAndroidLauncher(std::shared_ptr<const LauncherConfig> config);
    virtual ~QuasarAndroidLauncher();

    void init();
    void start();
    void stop();

private:
    void populateServices();

    template <typename T, typename... Args>
    void addService(Args&&... args);
    template <typename T>
    void addService(std::unique_ptr<T> service);
    void addStubService(const std::string& name);

    std::shared_ptr<YandexIO::XivaPushAliceRequester> xivaAliceRequester_;
    std::shared_ptr<YandexIO::SpotterConfigurer> spotterConfigurer_;
    std::shared_ptr<const LauncherConfig> config_;
    std::shared_ptr<YandexIO::IDevice> device_;
    std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory_;
    std::unique_ptr<quasar::YandexIOEndpoint> endpoint_;
};
