#include "cold_start_detector.h"

#include "yandex_io/libs/base/utils.h"
#include "yandex_io/libs/configuration/configuration.h"
#include "yandex_io/libs/logging/logging.h"

#include <fstream>

namespace quasar {
    ColdStartDetector::ColdStartDetector(std::shared_ptr<YandexIO::IDevice> device)
        : device_(device)
    {
    }

    bool ColdStartDetector::checkIfColdStart() {
        if (calledOncePerBoot_) {
            return false;
        }

        auto commonConfig = device_->configuration()->getServiceConfig("common");

        auto persistedPath = tryGetString(commonConfig, "persistBootIdPath", "");
        Y_VERIFY(!persistedPath.empty(), "persistedBootIdPath shouldn't be empty");

        auto systemBootIdPath = tryGetString(commonConfig, "systemBootIdPath", "");
        Y_VERIFY(!systemBootIdPath.empty(), "systemBootIdPath shouldn't be empty");

        Y_VERIFY(fileExists(systemBootIdPath), "system boot id not found");

        bool result;
        std::string systemBootId = getFileContent(systemBootIdPath);
        if (fileExists(persistedPath)) {
            auto savedBootId = getFileContent(persistedPath);
            result = savedBootId != systemBootId;
        } else {
            result = true;
        }

        std::ofstream fs(persistedPath);
        fs << systemBootId;

        calledOncePerBoot_ = true;

        return result;
    }

} // namespace quasar
