#include "empty_platform_collector.h"

using namespace quasar;

EmptyPlatformCollector::EmptyPlatformCollector(
    std::shared_ptr<YandexIO::IDevice> device,
    const std::shared_ptr<ipc::IIpcFactory>& ipcFactory,
    const std::shared_ptr<quasar::PingManager>& pingManager,
    std::chrono::milliseconds period)
    : MetricsCollectorBase(std::move(device), ipcFactory, pingManager, {{"/sys/class/thermal/thermal_zone0/temp", {"SOC", 0.001}}})
{
    executor_ = std::make_unique<quasar::PeriodicExecutor>(
        std::bind(&EmptyPlatformCollector::collectSystemMetrics, this),
        period);
}

void EmptyPlatformCollector::collectPlatformMetrics(IMetricConsumer& metrics)
{
    (void)metrics;
}
