#pragma once

#include <yandex_io/metrica/monitor/metrics_collector/metrics_collector.h>
#include <yandex_io/metrica/monitor/metrics_collector/ping_manager/ping_manager.h>

class ModulePlatformCollector final: public quasar::MetricsCollectorBase {
public:
    ModulePlatformCollector(
        std::shared_ptr<YandexIO::IDevice> device,
        const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
        const std::shared_ptr<quasar::PingManager>& pingManager,
        std::chrono::milliseconds period);

protected:
    void collectPlatformMetrics(quasar::IMetricConsumer& metrics) override;

private:
    struct EmmcStatInfo {
        int64_t lifetimeTypeA = 0;
        int64_t lifetimeTypeB = 0;
        int64_t preEOLinfo = 0;
    };

    static std::optional<EmmcStatInfo> getEmmcInfo();
};
