#pragma once

#include <yandex_io/metrica/monitor/metrics_collector/ping_manager/ping_manager.h>
#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/libs/threading/lifetime.h>
#include <yandex_io/libs/threading/unique_callback.h>
#include <yandex_io/interfaces/user_config/connector/user_config_provider.h>

#include <chrono>

namespace quasar {
    class PingManagerWrapper {
    public:
        PingManagerWrapper(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<IUserConfigProvider> userConfigProvider);
        ~PingManagerWrapper();
        void startQuickPings(const std::string& reason);
        void setNetworkStatus(YandexIO::ITelemetry::IParams::NetworkStatus status);

    private:
        const std::shared_ptr<PingManager> pingManager_;
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        quasar::Lifetime lifetime_;
        Json::Value config_;
        int64_t startedAt_;
        bool configWasReceived_ = false;
        std::shared_ptr<NamedCallbackQueue> worker_;
        UniqueCallback uniqueCallback_;
        std::string reason_;

        static int64_t uptime();
        void onPingerEvent(const Pinger::Event& event);
    };
} /* namespace quasar */
