#include "platform_metrics.h"

#include "empty_platform_collector.h"
#include "module_platform_collector.h"

#include <yandex_io/libs/logging/logging.h>

namespace quasar {

    std::unique_ptr<IMetricsCollector> createMetricsCollector(const std::shared_ptr<YandexIO::IDevice>& device,
                                                              const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
                                                              const std::shared_ptr<quasar::PingManager>& pingManager) {
        const auto& monitordConfig = device->configuration()->getServiceConfig("monitord");
        const auto periodSec = tryGetInt(monitordConfig, "metricsCollectorPeriodSec", 10);

        const auto collectorType = tryGetString(monitordConfig, "metricsCollectorType");
        if (collectorType == "module") {
            YIO_LOG_INFO("creating ModulePlatformCollector...");
            return std::make_unique<ModulePlatformCollector>(device, ipcFactory, pingManager, std::chrono::seconds{periodSec});
        }
        YIO_LOG_INFO("creating EmptyPlatformCollector...");
        return std::make_unique<EmptyPlatformCollector>(device, ipcFactory, pingManager, std::chrono::seconds{periodSec});
    }
} // namespace quasar
