@file:Suppress("unused")

package com.yandex.tv.yamake

import org.gradle.api.file.RegularFileProperty
import org.gradle.api.provider.Property
import ru.yandex.external_builder.BaseExternalBuilderExtension
import java.io.File

/**
 * Describes parameters used to configure lite external builder in Gradle scripts.
 */
abstract class YaMakeExtension: BaseExternalBuilderExtension() {

    internal abstract val targetDir: RegularFileProperty
    internal abstract val targetName: Property<String>

    fun targetDir(path: File) {
        targetDir.set(path)
    }

    fun targetName(fileName: String) {
        targetName.set(fileName)
    }

    companion object {
        const val EXT_NAME = "yaMake"
    }

}
