@file:Suppress("unused")

package ru.yandex.external_builder

import org.gradle.api.file.RegularFileProperty
import org.gradle.api.internal.provider.DefaultProvider
import org.gradle.api.provider.Property
import org.gradle.api.provider.Provider
import java.io.File

/**
 * Extension for general ya make configuration.
 */
abstract class BaseExternalBuilderExtension {

    internal abstract val yaTool: RegularFileProperty
    internal abstract val useYTCache: Property<Boolean>
    internal abstract val ytCacheProxy: Property<String>
    internal abstract val ytCacheDir: Property<String>
    internal abstract val ytCachePut: Property<Boolean>

    fun yaTool(path: File) {
        yaTool.set(path)
    }

    fun useYTCache(value: Boolean) {
        useYTCache.set(value)
    }

    fun ytCacheProxy(value: String) {
        ytCacheProxy.set(value)
    }

    fun ytCacheDir(value: String) {
        ytCacheDir.set(value)
    }

    fun ytCachePut(value: Boolean) {
        ytCachePut.set(value)
    }

    fun getYtArgs(): List<String> {
        val args = arrayListOf<String>()

        var useYtCache = false
        if (useYTCache.getOrElse(false)) {
            args.add("--yt-store")
            useYtCache = true
        }

        val ytProxy = ytCacheProxy.orNull
        if (ytProxy != null || useYtCache) {
            args.add("--yt-proxy")
            args.add(ytProxy ?: YT_PROXY_DEFAULT)
        }

        val ytDir = ytCacheDir.orNull
        if (ytDir != null || useYtCache) {
            args.add("--yt-dir")
            args.add(ytDir ?: YT_DIR_DEFAULT)
        }

        if (ytCachePut.getOrElse(false)) {
            args.add("--yt-put")
        }
        return args
    }

    fun getYtArgsProvider(): Provider<List<String>> {
        return DefaultProvider {
            getYtArgs()
        }
    }

    companion object {
        private const val YT_PROXY_DEFAULT = "hahn"
        private const val YT_DIR_DEFAULT = "//home/quasar_infra/yamake_cache"
    }

}
