@file:Suppress("unused")

package ru.yandex.external_builder

import groovy.lang.Closure
import org.gradle.api.NamedDomainObjectContainer
import org.gradle.api.Project
import org.gradle.api.file.RegularFileProperty
import java.io.File

/**
 * Describes parameters used to configure external builder in Gradle scripts.
 */
abstract class ExternalBuilderExtension(
    val flavors: NamedDomainObjectContainer<Flavor>
): BaseExternalBuilderExtension() {

    internal abstract val packageJson: RegularFileProperty

    fun packageJson(path: File) {
        packageJson.set(path)
    }

    fun flavors(variantsClosure: Closure<*>) {
        flavors.configure(variantsClosure)
    }

    companion object {
        const val EXT_NAME = "externalBuilder"
    }

    class Flavor(var name: String? = null) {
        var packageJson: File? = null
        var dimension: String? = null

        fun packageJson(value: File?) {
            packageJson = value
        }

        fun dimension(value: String?) {
            dimension = value
        }
    }
}
