package ru.yandex.io.common

import java.util.concurrent.CountDownLatch
import java.util.concurrent.TimeUnit

class AliceSingleRequestCallback: AliceRequestCallback {
    private val latch: CountDownLatch = CountDownLatch(1)

    var response: String? = null

    override fun onStarted(requestId: String) {
    }

    override fun onSuccess(requestId: String, response: String?) {
        this.response = response
        latch.countDown()
    }

    override fun onError(requestId: String, errorCode: String?, errorText: String?) {
        latch.countDown()
    }

    fun await(timeout: Long, unit: TimeUnit) {
        latch.await(timeout, unit)
    }
}
