package ru.yandex.io.sdk

import android.content.Context
import android.os.Build
import com.yandex.launcher.logger.KLogger
import java.lang.Exception

abstract class AndroidDeviceInfo(private val context: Context) : DeviceInfo {

    private companion object {
        const val TAG = "AndroidDeviceInfo"
    }

    override val appId: String get() = context.packageName

    override val appVersion: String by lazy {
        try {
            context.packageManager.getPackageInfo(context.packageName, 0).versionName!!
        } catch (e: Exception) {
            KLogger.w(TAG, e) { "Cannot get appVersion: ${e.message}" }
            ""
        }
    }

    override val os: String = "android"

    override val osVersion: String = Build.VERSION.RELEASE!!

    override val softwareVersion: String = Build.HARDWARE!!

    override val deviceType: String by lazy {
        quasarPlatform
    }

    override val deviceManufacturer: String = Build.MANUFACTURER!!

}
