package ru.yandex.io.sdk

import ru.yandex.io.sdk.utils.DecryptionPadding
import ru.yandex.io.sdk.utils.isBetaOrDebug

abstract class IoSdkSettings {
    open val cryptographyType: CryptographyType = CryptographyType.PLAIN_FILE
    open val plainFileRsaPadding: DecryptionPadding = DecryptionPadding.RSA_PKCS1_OAEP_PADDING
    open val logLevel: LogLevel = if (isBetaOrDebug()) LogLevel.DEBUG else LogLevel.INFO

    open val disableBackgroundServices = false
    open val useNetworkIpc = false
    open val registerCapabilitiesEndpoint = true

    open fun getUserAgent(deviceInfo: DeviceInfo): String {
        return String.format(
            "%s/%s (%s %s; Android %s)",
            deviceInfo.appId,
            deviceInfo.appVersion,
            deviceInfo.deviceManufacturer,
            deviceInfo.deviceType,
            deviceInfo.osVersion
        )
    }

    enum class CryptographyType(internal val sdkName: String) {
        PLAIN_FILE("plainFile"),
        KEYMASTER_PROXY("keymasterProxy")
    }

    enum class LogLevel(internal val sdkName: String) {
        DEBUG("debug"),
        INFO("info")
    }

    companion object {
        val DEFAULT = object : IoSdkSettings() {}
    }
}
