package ru.yandex.io.sdk;

import androidx.annotation.NonNull;

public interface MediaObserver {
    enum ContentType {
        MUSIC,
        VIDEO
    }

    void onMediaError(@NonNull ContentType contentType);

    void onMediaRequest(@NonNull ContentType contentType);
    void onMediaStarted(@NonNull ContentType contentType);
    void onMediaPaused(@NonNull ContentType contentType);
    void onMediaResumed(@NonNull ContentType contentType);

    void onMediaSwitchedForward(@NonNull ContentType contentType);
    void onMediaSwitchedBackward(@NonNull ContentType contentType);
    void onMediaLiked(@NonNull ContentType contentType);
    void onMediaDisliked(@NonNull ContentType contentType);
}
