package ru.yandex.io.sdk

import android.content.Context
import java.io.File

/**
 * Stores paths for Quasar Yandex IO directories.
 */
class QuasarDirs(context: Context) {
    val systemDir by lazy {
        File("${context.filesDir}/system").apply { mkdirs() }
    }
    val dataDir by lazy {
        File("${context.filesDir}/data").apply { mkdirs() }
    }
    val workDir by lazy {
        File("${context.filesDir}/workdir").apply { mkdirs() }
    }
}
