package ru.yandex.io.sdk.audio

import android.media.AudioFormat
import com.yandex.launcher.logger.KLogger
import ru.yandex.io.sdk.jni.AudioSource
import java.nio.ByteBuffer

internal class AndroidToQuasarAudioBus {
    private val audioDataPusher = object : AndroidAudioSource.Listener {
        override fun onNext(audioBuffer: ByteBuffer, audioFormat: AudioFormat) {
            val length = audioBuffer.remaining()
            val channelsCount = audioFormat.channelCount
            val channelBytes = Array(channelsCount) { ByteArray(length /channelsCount)}
            val bytesPerSample = when (audioFormat.encoding) {
                AudioFormat.ENCODING_PCM_8BIT -> 1
                AudioFormat.ENCODING_PCM_16BIT -> 2
                AudioFormat.ENCODING_PCM_32BIT -> 4
                else -> throw Exception("Unknown audio encoding: ${audioFormat.encoding}")
            }

            for (i in 0 until length) {
                val channelIndex = (i / bytesPerSample) % channelsCount
                val byteOffsetInSample = i % bytesPerSample
                val sampleOffsetInChannel = i / (channelsCount * bytesPerSample)
                channelBytes[channelIndex][sampleOffsetInChannel * bytesPerSample + byteOffsetInSample] = audioBuffer[i]
            }

            val channels = channelBytes.mapIndexed { i, it -> ChannelData(ByteBuffer.wrap(it), name = "channel_$i")}
            quasarAudioSource.pushAudioData(channels)
        }
        override fun onError(throwable: Throwable) {
            KLogger.e(TAG, throwable) { "Exception in AndroidAudioSource: ${throwable.message}" }
        }
    }

    private val quasarAudioSource = AudioSource()
    private val androidAudioSource = AndroidAudioSource(audioDataPusher)

    fun start() {
        androidAudioSource.start()
        KLogger.i(TAG) { "Started audio recording" }
    }

    fun stop() {
        androidAudioSource.stop()
        KLogger.i(TAG) { "Suspend audio recording" }
    }

    private companion object {
        const val TAG = "AndroidToQuasarAudioBus"
    }
}
