package ru.yandex.io.sdk.audio

import ru.yandex.io.sdk.jni.AudioSource
import ru.yandex.io.sdk.utils.toByteString
import ru.yandex.quasar.protobuf.YandexIO.IOAudioChannel
import java.nio.ByteBuffer

class ChannelData(
    val data: ByteBuffer,
    val type: Type = Type.VQE,
    val name: String = DEFAULT_CHANNEL_NAME,
    val isForRecognition: Boolean = true,
    val vqeType: String = DEFAULT_VQE_TYPE,
    val doaAngle: Double = DEFAULT_DOA_ANGLE,
    val sampleRate: Int = AudioSource.REQUIRED_SAMPLE_RATE
) {

    fun toProtobuf(): IOAudioChannel {
        return IOAudioChannel.newBuilder()
            .setType(IOAudioChannel.Type.forNumber(type.ordinal))
            .setName(name)
            .setData(data.toByteString())
            .setIsForRecognition(isForRecognition)
            .setMeta(
                IOAudioChannel.Meta.newBuilder()
                    .setVqeInfo(IOAudioChannel.Meta.VqeInfo.newBuilder().setType(vqeType))
                    .setDoaAngle(doaAngle)
                    .build()
            )
            .setSampleRate(sampleRate)
            .build()
    }

    enum class Type {
        RAW,
        VQE,
        FEEDBACK,
        BEAMFORMING,
        BACKGROUND_NOISE_REDUCER,
        MAIN_MIC_SYNC,
        AUXILIARY_MIC_SYNC,
        FEEDBACK_SYNC
    }

    companion object {
        private const val DEFAULT_CHANNEL_NAME = "Android"
        private const val DEFAULT_VQE_TYPE = "unknown"
        private const val DEFAULT_DOA_ANGLE = 45.0
    }
}
