package ru.yandex.io.sdk.capability;

import androidx.annotation.NonNull;

import java.util.concurrent.CopyOnWriteArrayList;

import ru.yandex.alice.protos.endpoint.capabilities.AllCapabilitiesProto;

public abstract class Capability {
    protected CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList<>();

    /**
     * Capability must define unique id inside endpoint scope
     */
    @NonNull
    public abstract String getId();

    @NonNull
    public abstract AllCapabilitiesProto.TCapabilityHolder getState();

    @NonNull
    public abstract DirectiveHandler getDirectiveHandler();

    @SuppressWarnings("unused")
    @NonNull
    public final byte[] getCapabilityState() {
        return getState().toByteArray();
    }

    @SuppressWarnings("unused")
    public final void addListener(@NonNull Listener listener) {
        listeners.add(listener);
    }

    @SuppressWarnings("unused")
    public final void removeListener(@NonNull Listener listener) {
        listeners.remove(listener);
    }

    protected final void notifyCapabilityStateChanged() {
        for (Listener listener : listeners) {
            listener.onCapabilityStateChanged(this, getState());
        }
    }

    public interface Listener {
        void onCapabilityStateChanged(@NonNull Capability capability, @NonNull AllCapabilitiesProto.TCapabilityHolder state);
    }
}
