package ru.yandex.io.sdk.capability;

import androidx.annotation.NonNull;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yandex.launcher.logger.Logger;

import ru.yandex.quasar.protobuf.ModelObjects.Directive;

public abstract class DirectiveHandler {
    private static final String TAG = "DirectiveHandler";

    @NonNull
    public abstract String getEndpointId();

    @NonNull
    public abstract String getHandlerName();

    @NonNull
    public abstract String[] getSupportedDirectiveNames();

    public abstract void handleDirective(@NonNull Directive directive);

    public abstract void cancelDirective(@NonNull Directive directive);

    public abstract void prefetchDirective(@NonNull Directive directive);

    public final void handleDirective(byte[] directive) {
        try {
            handleDirective(Directive.parseFrom(directive));
        } catch (InvalidProtocolBufferException e) {
            Logger.e(TAG, "Invalid protocol buffer", e);
        }
    }

    public final void cancelDirective(byte[] directive) {
        try {
            cancelDirective(Directive.parseFrom(directive));
        } catch (InvalidProtocolBufferException e) {
            Logger.e(TAG, "Invalid protocol buffer", e);
        }
    }

    public final void prefetchDirective(byte[] directive) {
        try {
            prefetchDirective(Directive.parseFrom(directive));
        } catch (InvalidProtocolBufferException e) {
            Logger.e(TAG, "Invalid protocol buffer", e);
        }
    }
}
