package ru.yandex.io.sdk.capability

import ru.yandex.alice.protos.endpoint.EndpointProto

abstract class IoEndpoint {

    abstract fun getId(): String
    abstract fun getState(): EndpointProto.TEndpoint

    abstract fun addCapability(capability: Capability)
    abstract fun removeCapability(capability: Capability)
    abstract fun getCapabilities(): List<Capability>

    abstract fun addListener(listener: Listener)
    abstract fun removeListener(listener: Listener)

    fun findCapabilityById(capabilityId: String): Capability? {
        val capabilities = getCapabilities()
        for (capability in capabilities) {
            if (capabilityId == capability.id) {
                return capability
            }
        }
        return null
    }

    interface Listener {
        fun onCapabilityAdded(capability: Capability)
        fun onCapabilityRemoved(capability: Capability)
    }
}
