package ru.yandex.io.sdk.jni;

import java.util.List;

import ru.yandex.io.sdk.audio.ChannelData;
import ru.yandex.quasar.protobuf.YandexIO;

public class AudioSource {
    public static final int REQUIRED_SAMPLE_RATE = 16000;

    public void pushAudioData(List<ChannelData> data) {
        YandexIO.IOAudioData.Builder ioAudioDataBuilder = YandexIO.IOAudioData.newBuilder();
        for (ChannelData channelData : data) {
            ioAudioDataBuilder.addChannels(channelData.toProtobuf());
        }
        doPushAudioData(ioAudioDataBuilder.build().toByteArray());
    }

    private native void doPushAudioData(byte[] audioDataSerialized);
}
