package ru.yandex.io.sdk.jni;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yandex.launcher.logger.Logger;

import java.util.Map;

import ru.yandex.quasar.protobuf.ModelObjects;

public final class DeviceCryptography {

    private static final String TAG = "DeviceCryptography";

    @Nullable
    public ModelObjects.BleDecryptCredentialsStatus decryptBlePlainTextCredentials(@NonNull String plainText) {
        Logger.d(TAG, "decryptBlePlainTextCredentials: start");
        byte[] credentialsStatusBytes = doNativeDecryptBlePlainTextCredentials(plainText);
        try {
            return ModelObjects.BleDecryptCredentialsStatus.parseFrom(credentialsStatusBytes);
        } catch (InvalidProtocolBufferException e) {
            Logger.e(TAG, "Invalid protocol buffer: " + e.getMessage(), e);
            return null;
        }
    }

    @Nullable
    public ModelObjects.BleDecryptCredentialsStatus decryptBleCredentials(@NonNull ModelObjects.EncryptedSetupCredentialsMessage credentials) {
        Logger.d(TAG, "decryptBleCredentials: start");
        byte[] credentialsStatusBytes = doNativeDecryptBleCredentials(credentials.toByteArray());
        try {
            return ModelObjects.BleDecryptCredentialsStatus.parseFrom(credentialsStatusBytes);
        } catch (InvalidProtocolBufferException e) {
            Logger.e(TAG, "Invalid protocol buffer: " + e.getMessage(), e);
            return null;
        }
    }

    @NonNull
    public Map<String, String> prepareSignedHeaders(@NonNull String plainText) {
        Logger.d(TAG, "getSignedHeaders: start");

        Map<String, String> result = doPrepareSignedHeaders(plainText);

        Logger.d(TAG, "getSignedHeaders: end with %s", result.toString());
        return result;
    }

    private native byte[] doNativeDecryptBlePlainTextCredentials(String plainText);
    private native byte[] doNativeDecryptBleCredentials(byte[] bleCredentialsSerialized);
    private native Map<String, String> doPrepareSignedHeaders(String plainText);
}
