package ru.yandex.io.sdk.jni;

import android.os.Handler;
import android.os.Looper;

import com.yandex.launcher.logger.Logger;

import androidx.annotation.NonNull;

public abstract class JniAccountManager {
    private final String TAG = "JniAccountManager";

    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public final void switchUser(@NonNull String xCode) {
        mainHandler.post(() -> doSwitchUser(xCode));
    }

    public abstract void doSwitchUser(@NonNull String xCode);

    public void register() {
        try {
            doRegister();
        } catch (Exception e) {
            Logger.e(TAG, "Failed to register in native code", e);
        }
    }

    public void unregister() {
        try {
            doUnregister();
        } catch (Exception e) {
            Logger.e(TAG, "Failed to unregister in native code", e);
        }
    }

    private native void doRegister();

    private native void doUnregister();
}
