package ru.yandex.io.sdk.jni;

import android.os.Handler;

import ru.yandex.io.common.AliceRequestCallback;

public final class JniAliceRequestCallback {

    private final Handler handler;
    private final AliceRequestCallback callback;

    public JniAliceRequestCallback(final Handler handler, final AliceRequestCallback callback) {
        this.handler = handler;
        this.callback = callback;
    }

    public void onStarted(final String requestId) {
        handler.post(() -> callback.onStarted(requestId));
    }

    public void onSuccess(final String requestId, final String response) {
        handler.post(() -> callback.onSuccess(requestId, response));
    }

    public void onError(final String requestId, final String errorCode, final String errorText) {
        handler.post(() -> callback.onError(requestId, errorCode, errorText));
    }
}
