package ru.yandex.io.sdk.jni;

import android.os.Handler;
import android.os.Looper;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yandex.launcher.logger.Logger;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import ru.yandex.io.sdk.AudioClientEventObserver;
import ru.yandex.quasar.protobuf.ModelObjects;

public class JniAudioClientEventObserver {
    private static final String TAG = "JniAudioClientEventObserver";

    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    @NonNull
    private final List<AudioClientEventObserver> observers = new ArrayList<>();

    @MainThread
    public void addObserver(@NonNull AudioClientEventObserver observer) {
        observers.add(observer);
    }

    @MainThread
    public void removeObserver(@NonNull AudioClientEventObserver observer) {
        observers.remove(observer);
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onAudioClientEvent(byte[] packedAudioClientEvent) {
        ModelObjects.AudioClientEvent unpackedAudioClientEvent;
        try {
            unpackedAudioClientEvent = ModelObjects.AudioClientEvent.parseFrom(packedAudioClientEvent);
        } catch (InvalidProtocolBufferException e) {
            Logger.e(TAG, "Invalid protocol buffer: " + e.getMessage(), e);
            return;
        }
        Logger.d(TAG, "Got audio client event from JNI");
        mainHandler.post(() -> {
            for (AudioClientEventObserver observer : observers) {
                observer.onAudioClientEvent(unpackedAudioClientEvent);
            }
        });
    }

    public void register() {
        try {
            Logger.d(TAG, "Audio client event observer attempt to register in IO SDK");
            doRegister();
            Logger.d(TAG, "Audio client event succeeded to register in IO SDK");
        } catch (Throwable throwable) {
            Logger.e(TAG, "Audio client event fails to register in IO SDK", throwable);
        }
    }

    public void reset() {
        doReset();
    }

    private native void doRegister();
    private native void doReset();
}
