package ru.yandex.io.sdk.jni;

import android.os.Handler;
import android.os.Looper;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;

import com.yandex.launcher.logger.Logger;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.io.sdk.AuthObserver;

public class JniAuthObserver implements AuthObserver {
    private static final String TAG = "JniAuthObserver";

    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    @NonNull
    private final List<AuthObserver> observers = new ArrayList<>();

    @MainThread
    public void addObserver(@NonNull AuthObserver observer) {
        observers.add(observer);
    }

    @MainThread
    public void removeObserver(@NonNull AuthObserver observer) {
        observers.remove(observer);
    }

    public void register() {
        try {
            Logger.d(TAG, "Auth observer attempt to register in IO SDK");
            doRegister();
            Logger.d(TAG, "Auth observer succeeded to register in IO SDK");
        } catch (Throwable throwable) {
            Logger.e(TAG, "Auth observer fails to register in IO SDK", throwable);
        }
    }

    @Override
    public void onInvalidOAuthToken(@NonNull String token) {
        mainHandler.post(() -> {
            for (AuthObserver observer : observers) {
                observer.onInvalidOAuthToken(token);
            }
        });

    }

    @Override
    public void onAuthenticationStatus(@NonNull String oauthCode, boolean isOk, @NonNull String message) {
        mainHandler.post(() -> {
            for (AuthObserver observer : observers) {
                observer.onAuthenticationStatus(oauthCode, isOk, message);
            }
        });
    }

    @Override
    public void onInvalidAuthentication(@NonNull String uid) {
        mainHandler.post(() -> {
            for (AuthObserver observer : observers) {
                observer.onInvalidAuthentication(uid);
            }
        });
    }

    public void reset() {
        doReset();
    }

    private native void doRegister();
    private native void doReset();
}
