package ru.yandex.io.sdk.jni;

import android.os.Handler;
import android.os.Looper;

import com.yandex.launcher.logger.Logger;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import ru.yandex.io.sdk.DirectiveObserver;

public class JniDirectiveObserver implements DirectiveObserver {
    private static final String TAG = "DirectiveObserver";

    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    @NonNull
    private final List<DirectiveObserver> observers = new ArrayList<>();

    @MainThread
    public void addObserver(@NonNull DirectiveObserver observer) {
        observers.add(observer);
    }

    @MainThread
    public void removeObserver(@NonNull DirectiveObserver observer) {
        observers.remove(observer);
    }

    public void register() {
        try {
            Logger.d(TAG, "Directive observer attempt to register in IO SDK");
            doRegister();
            Logger.d(TAG, "Directive observer succeeded to register in IO SDK");
        } catch (Throwable throwable) {
            Logger.e(TAG, "Directive observer fails to register in IO SDK", throwable);
        }
    }

    @Override
    public void onDirective(@NonNull String name, @NonNull String vinsRequestId, @NonNull String jsonPayload) {
        mainHandler.post(() -> {
            for (DirectiveObserver observer : observers) {
                observer.onDirective(name, vinsRequestId, jsonPayload);
            }
        });
    }

    public void reset() {
        doReset();
    }

    private native void doRegister();
    private native void doReset();
}
