package ru.yandex.io.sdk.jni;

import android.os.Handler;
import android.os.Looper;

import com.yandex.launcher.logger.Logger;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import ru.yandex.io.sdk.MediaObserver;
import ru.yandex.io.sdk.utils.Consumer;

public class JniMediaObserver {
    private static final String TAG = "JniMediaObserver";

    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    @NonNull
    private final List<MediaObserver> observers = new ArrayList<>();

    @MainThread
    public void addObserver(@NonNull MediaObserver observer) {
        observers.add(observer);
    }

    @MainThread
    public void removeObserver(@NonNull MediaObserver observer) {
        observers.remove(observer);
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaError(int contentType) {
        dispatch(observer -> observer.onMediaError(getJavaContentType(contentType)));
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaRequest(int contentType) {
        dispatch(observer -> observer.onMediaRequest(getJavaContentType(contentType)));
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaStarted(int contentType) {
        dispatch(observer -> observer.onMediaStarted(getJavaContentType(contentType)));
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaPaused(int contentType) {
        dispatch(observer -> observer.onMediaPaused(getJavaContentType(contentType)));
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaResumed(int contentType) {
        dispatch(observer -> observer.onMediaResumed(getJavaContentType(contentType)));
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaSwitchedForward(int contentType) {
        dispatch(observer -> observer.onMediaSwitchedForward(getJavaContentType(contentType)));
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaSwitchedBackward(int contentType) {
        dispatch(observer -> observer.onMediaSwitchedBackward(getJavaContentType(contentType)));
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaLiked(int contentType) {
        dispatch(observer -> observer.onMediaLiked(getJavaContentType(contentType)));
    }

    @SuppressWarnings({"unused", "RedundantSuppression"})
    public void onMediaDisliked(int contentType) {
        dispatch(observer -> observer.onMediaDisliked(getJavaContentType(contentType)));
    }

    private void dispatch(@NonNull Consumer<MediaObserver> notifyObserver) {
        mainHandler.post(() -> {
            for (MediaObserver observer : observers) {
                notifyObserver.accept(observer);
            }
        });
    }

    @NonNull
    private MediaObserver.ContentType getJavaContentType(int value) {
        return MediaObserver.ContentType.values()[value];
    }

    public void register() {
        try {
            Logger.d(TAG, "Media observer attempt to register in IO SDK");
            doRegister();
            Logger.d(TAG, "Media observer succeeded to register in IO SDK");
        } catch (Throwable throwable) {
            Logger.e(TAG, "Media observer fails to register in IO SDK", throwable);
        }
    }

    public void reset() {
        doReset();
    }

    private native void doRegister();
    private native void doReset();
}
