package ru.yandex.io.sdk.jni

import com.yandex.launcher.logger.Logger
import ru.yandex.io.sdk.utils.tryOrLog


class JniVinsResponsePreprocessor {

    private var handler: Handler = Handler.DEFAULT

    fun register() =
        tryOrLog(TAG, "register in IO SDK", ::doRegister) != null

    fun handle(source: String): String = handler.handle(source)

    fun setHandler(handler: Handler) {
        this.handler = handler
    }

    private external fun doRegister()

    companion object {
        const val TAG = "JniVinsResponsePreprocessor"
    }

    fun interface Handler {

        fun handle(source: String): String

        companion object {
            val DEFAULT = Handler { source ->
                Logger.d(TAG, "Received $source")
                source
            }
        }
    }
}
