package ru.yandex.io.sdk.jni

import ru.yandex.quasar.protobuf.ModelObjects.NsdInfo
import ru.yandex.quasar.protobuf.ModelObjects.NsdInfoList

import com.yandex.launcher.logger.Logger

interface IMdnsObserver {
    fun onNsdEnable(guestMode: Boolean, port: Int, stereopair: Int, tandem: Int)
    fun onNsdDisable()
}

abstract class MdnsObserver: IMdnsObserver {
    companion object {
        private const val TAG = "MdnsObserver"
    }

    fun register() {
        try {
            Logger.d(TAG, "MdnsObserver attempt to register in IO SDK")
            doRegister()
            Logger.d(TAG, "MdnsObserver succeeded to register in IO SDK")
        } catch (throwable: Throwable) {
            Logger.e(TAG, "MdnsObserver fails to register in IO SDK", throwable)
        }
    }

    fun unregister() {
        try {
            Logger.d(TAG, "MdnsObserver attempt to unregister in IO SDK")
            doUnregister()
            Logger.d(TAG, "MdnsObserver succeeded to unregister in IO SDK")
        } catch (throwable: Throwable) {
            Logger.e(TAG, "MdnsObserver fails to unregister in IO SDK", throwable)
        }
    }

    fun onHostDiscovered(nsdInfo: NsdInfo) {
        val bytes = nsdInfo.toByteArray()
        doOnHostDiscovered(bytes)
    }

    fun onHostListDiscovered(nsdInfoList: NsdInfoList) {
        val bytes = nsdInfoList.toByteArray()
        doOnHostListDiscovered(bytes)
    }

    fun onHostLost(nsdInfo: NsdInfo) {
        val bytes = nsdInfo.toByteArray()
        doOnHostLost(bytes)
    }

    private external fun doRegister()
    private external fun doUnregister()
    private external fun doOnHostDiscovered(byteArray: ByteArray)
    private external fun doOnHostListDiscovered(byteArray: ByteArray)
    private external fun doOnHostLost(byteArray: ByteArray)
}
