package ru.yandex.io.sdk.jni;

import com.yandex.launcher.logger.Logger;

public abstract class VolumeManager {
    private static final String TAG = "VolumeManager";

    public void register() {
        try {
            Logger.d(TAG, "Volume manager attempt to register in IO SDK");
            doRegister();
            Logger.d(TAG, "Volume manager succeeded to register in IO SDK");
        } catch (Exception exc) {
            Logger.e(TAG, "Volume manager fails to register in IO SDK", exc);
        }
    }

    public void unregister() {
        try {
            doUnregister();
        } catch (Exception exc) {
            Logger.e(TAG, "Volume manager fails to unregister from IO SDK", exc);
        }
    }

    public void reportVolume(int volume, boolean isMuted) {
        try {
            doReportVolume(volume, isMuted);
        } catch (Exception exc) {
            Logger.e(TAG, "Cannot report volume", exc);
        }
    }

    public abstract int getVolume();
    public abstract void setVolume(int volume);
    public abstract void adjustVolume(int direction);
    public abstract boolean isMuted();
    public abstract void mute();
    public abstract void unmute();

    private native void doRegister();
    private native void doUnregister();
    private native void doReportVolume(int volume, boolean isMuted);
}
