package ru.yandex.io.sdk.utils

import java.io.InputStream
import java.nio.ByteBuffer

internal class ByteBufferInputStream(var buffer: ByteBuffer) : InputStream() {
    override fun read(): Int {
        if (!buffer.hasRemaining())  {
            return -1
        }
        return (buffer.get().toInt()) and 0xFF
    }

    override fun read(bytes: ByteArray, offset: Int, length: Int): Int {
        if (!buffer.hasRemaining()) {
            return -1
        }
        val readLength = length.coerceAtMost(buffer.remaining())
        buffer[bytes, offset, readLength]
        return readLength
    }
}